<?Lassoscript
// Last modified: 1/15/07 by ECL, Landmann InterActive
// Prepared for Lasso Summit 07

// FUNCTIONALITY
// Displays the bug history

// Used to determine if date output
Local:'vDateModified' = string;
Local:'vDateHeadNew' = string;
Var:'vFieldname' = string;
Var:'vOld_Value' = string;
Var:'vNew_Value' = string;
Var:'vUser_ID' = string;

Local:'HistoryLineItem' = string;

Var:'BugFieldsMap' = map;
$BugFieldsMap = (map:
	'ProjectIDLabel' = 		'Project',
	'VersionIDLabel' = 		'Version',
	'ClosedInVersIDLabel' = 'Closed In Version',
	'ToBeClosedVers_ID' = 	'To Be Closed In Version',
	'SeverityIDLabel' = 	'Severity',
	'PriorityIDLabel' = 	'Priority',
	'StatusIDLabel' = 		'Status',
	'ResolutionIDLabel' = 	'Resolution',
	'BrowserIDLabel' = 		'Browser',
	'OSIDLabel' = 			'Operating System');

// Get the history
// If Found_Count = 0, there is no history, so just don't display anything
Var:'SQLGetBugHistory' = 'SELECT * FROM ' $svChangelogTable ' WHERE Bug_ID = "'($vBug_ID)'" ORDER BY ID';
Inline: $IV_SearchChangelog, -SQL=$SQLGetBugHistory;

	If: !(Found_Count) == 0;
?>
<br>
<table border="0" cellpadding="5" width="520">
	<tr>
		<td colspan="2" bgcolor="#666666" class="tablehead_10_white">History</td>
	</tr>
<?Lassoscript
	Records;
		$vFieldname = (Field:'Fieldname');
		$vOld_Value = (Field:'Old_Value');
		$vNew_Value = (Field:'New_Value');
		$vUser_ID = (Field:'User_ID');
		#vDateHeadNew = (Field:'DateModified');
		#HistoryLineItem = '';

Select: $vFieldname;
	Case:'Project_ID';
		#HistoryLineItem += '\t\t\t<strong>' ($BugFieldsMap->Find:'ProjectIDLabel') '</strong> changed to <strong>' (GetPriorityName: -ID=$vOld_Value) '</strong> by ' (GetUserName: -ID=$vUser_ID) ' <span class="dim">(Was: '(GetPriorityName: -ID=$vOld_Value) ')</span><br>\n';
	Case:'Version_ID';
		#HistoryLineItem += '\t\t\t<strong>' ($BugFieldsMap->Find:'VersionIDLabel') '</strong> changed to <strong>' (GetVersionName: -ID=$vNew_Value) '</strong> by ' (GetUserName: -ID=$vUser_ID) ' <span class="dim">(Was: ' (GetVersionName: -ID=$vOld_Value) ')</span><br>\n';
	Case:'ClosedInVers_ID';
		#HistoryLineItem += '\t\t\<strong>' ($BugFieldsMap->Find:'ClosedInVersIDLabel') '</strong> changed to <strong>' (GetVersionName: -ID=$vNew_Value) '</strong> by ' (GetUserName: -ID=$vUser_ID) ' <span class="dim">(Was: ' (GetVersionName: -ID=$vOld_Value) ')</span><br>\n';
	Case:'ToBeClosedVers_ID';
		#HistoryLineItem += '\t\t\<strong>' ($BugFieldsMap->Find:'ToBeClosedVers_ID') '</strong> changed to <strong>' (GetVersionName: -ID=$vNew_Value) '</strong> by ' (GetUserName: -ID=$vUser_ID) ' <span class="dim">(Was: ' (GetVersionName: -ID=$vOld_Value) ')</span><br>\n';
	Case:'Title';
		#HistoryLineItem += '\t\t\t<strong>Title</strong> changed to <strong>' ($vNew_Value) '</strong> by ' (GetUserName: -ID=$vUser_ID) ' <span class="dim">(Was: ' (GetUserName: -ID=$vOld_Value) ')</span><br>\n';
	Case:'Description';
		#HistoryLineItem += '\t\t\t<strong>Description changed to ' ($vNew_Value) '</strong> by ' (GetUserName: -ID=$vUser_ID) ' <span class="dim">(Was: ' (GetUserName: -ID=$vOld_Value) ')</span><br>\n';
	Case:'Assigned_To';
		#HistoryLineItem += '\t\t\t<strong>Assigned to ' (GetUserName: -ID=$vNew_Value)'</strong> by ' (GetUserName: -ID=$vUser_ID) ' <span class="dim">(Was: ' (GetUserName: -ID=$vOld_Value) ')</span><br>\n';
	Case:'URL';
		#HistoryLineItem += '\t\t\t<strong>URL</strong> change to <strong>' ($vNew_Value) '</strong> by ' (GetUserName: -ID=$vUser_ID) ' <span class="dim">(Was: ' $vOld_Value ')</span><br>\n';
	Case:'Severity_ID';
		#HistoryLineItem += '\t\t\t<strong>' ($BugFieldsMap->Find:'SeverityIDLabel') '</strong> changed to <strong>' (GetSeverityName: -ID=$vNew_Value) '</strong> by ' (GetUserName: -ID=$vUser_ID) '  <span class="dim">(Was: ' (GetSeverityName: -ID=$vOld_Value) ')</span><br>\n';
	Case:'Priority_ID';
		#HistoryLineItem += '\t\t\t<strong>' ($BugFieldsMap->Find:'PriorityIDLabel') '</strong> changed to <strong>' (GetPriorityName: -ID=$vNew_Value) '</strong> by ' (GetUserName: -ID=$vUser_ID) '  <span class="dim">(Was: ' (GetPriorityName: -ID=$vOld_Value) ')</span><br>\n';
	Case:'Status_ID';
		#HistoryLineItem += '\t\t\t<strong>' ($BugFieldsMap->Find:'StatusIDLabel') '</strong> changed to <strong>' (GetStatusName: -ID=$vNew_Value) '</strong> by ' (GetUserName: -ID=$vUser_ID)' <span class="dim">(Was: ' (GetStatusName: -ID=$vOld_Value) ')</span></span><br>\n';
	Case:'Resolution_ID';
		#HistoryLineItem += '\t\t\t<strong>' ($BugFieldsMap->Find:'ResolutionIDLabel') '</strong> changed to <strong>' (GetResolutionName: -ID=$vNew_Value) '</strong> by ' (GetUserName: -ID=$vUser_ID) ' <span class="dim">(Was: ' (GetResolutionName: -ID=$vOld_Value) ')</span><br>\n';
	Case:'Browser_ID';
		#HistoryLineItem += '\t\t\t<strong>' ($BugFieldsMap->Find:'BrowserIDLabel') '</strong> changed to <strong>' (GetBrowserName: -ID=$vNew_Value) '</strong> by ' (GetUserName: -ID=$vUser_ID) '  <span class="dim">(Was: ' (GetBrowserName: -ID=$vOld_Value) ')</span><br>\n';
	Case:'OS_ID';
		#HistoryLineItem += '\t\t\t<strong>' ($BugFieldsMap->Find:'OSIDLabel') '</strong> changed to <strong>' (GetOSName: -ID=$vNew_Value) '</strong> by ' (GetUserName: -ID=$vUser_ID) '  <span class="dim">(Was: ' (GetOSName: -ID=$vNew_Value) ')</span><br>\n';
	// Comment is a special case. We grab the Old_Value which is the ID field of the record in the Comments table, then use a CT to get the info from the Comments table
	Case:'Comment';
		#HistoryLineItem += '\t\t\t<strong>Comment by ' (GetUserName: -ID=$vUser_ID) '</strong><br>\n'(GetComment: -ID=($vOld_Value));
	Case:'NewIssue';
		#HistoryLineItem += '\t\t\tNew issue.';
	Case:'Attachment';
		#HistoryLineItem += '\t\t\tAttachment "' (GetAttachmentName: -ID=($vOld_Value)) '" uploaded by ' (GetUserName: -ID=$vUser_ID) '<br>\n';
/Select;

?>	<tr>
		<td width="90" bgcolor="#cccccc">
			<div align="right" class="tablehead_10_black">
<?Lassoscript
// Output Date for first record only
			If: #vDateHeadNew != #vDateModified;
				#vDateHeadNew;
				#vDateModified = #vDateHeadNew;
			Else;
				#vDateModified = #vDateHeadNew;
			/If;
?>
			</div>
		</td>
		<td valign="top" bgcolor="#FFFFFF" class="tabletext_10_black">
			<div class="tablehead_10_black">
				[#HistoryLineItem]
			</div>
		</td>
	</tr>
	[/Records]
</table>
[/If]
[/Inline]
